<?php
/*******************************************************************************
* Image cache plugin extension                                                 *
* (C) Copyright Y2K Software s.a.s., Italy 2006-2007 - All Rights Reserved     *
* ---------------------------------------------------------------------------- *
* Saves images between the [IMG] and [/IMG] tags to file system                *
* Requires a full access folder (chmod 777) at <forumhome>/imgcache/           *
*******************************************************************************/

// Get cache ID (collision-free) -----------------------------------------------
function GetCacheID()
{
    global $db;

    $SQL = "INSERT INTO " . TABLE_PREFIX . "y2ksw_imgcache (ID) VALUES (0)";
    $db->query_write($SQL);

    return $db->insert_id();
}

function CacheImages($message_body, $old_message, $forum_home, $site_home)
{
    // Occurrance check --------------------------------------------------------
    $n = 0;
    foreach(array('img') as $key => $value)
    {
        $pos_end = -1;
        $tag1 = '[' . $value . ']';
        $tag2 = '[/' . $value . ']';
        $k = strlen($tag1);
        while(TRUE)
        {
            $pos_start = strpos(strtolower($message_body), $tag1, $pos_end + 1);
            if($pos_start === FALSE)
            {
                break;
            }
            
            $pos_end = strpos(strtolower($message_body), $tag2, $pos_start + 1);
            if($pos_end === FALSE)
            {
                break;
            }
        
            // Adjust pointers
            $pos_start += $k;
            $pos_end--;
        
            // Add reference to array if valid comparison
            $files[$n]['url'] = substr($message_body, $pos_start, $pos_end - $pos_start + 1);
            $n++;
        }
    }

    // If there was no occurrance, exit from function --------------------------
    if(!$n)
    {
        return $old_message;
    }

    // Don't change already cached files ---------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        if(strpos($files[$i]['url'], $forum_home . 'imgcache/') !== FALSE)
        {
            $files[$i]['url'] = '';
        }
        if(strpos($files[$i]['url'], $forum_home) !== FALSE)
        {
            $files[$i]['url'] = '';
        }
        if(strpos($files[$i]['url'], $site_home) !== FALSE)
        {
            $files[$i]['url'] = '';
        }
    }

    // Discard duplicates ------------------------------------------------------
    for($i = 0; $i < $n; $i++)
    {
        $a = $files[$i]['url'];
        if($a)
        {
            for($j = $i + 1; $j < $n; $j++)
            {
                if($files[$j]['url'] == $a)
                {
                    $files[$j]['url'] = '';
                }
            }
        }
    }

    // Get and save file contents to file system -------------------------------
    for($i = 0; $i < $n; $i++)
    {
        // Get content if url is valid
        if(@getimagesize($files[$i]['url']))
        {
            // A localhost file will fail, also not existing references
            $content = @file_get_contents($files[$i]['url']);
            $typemkhm=strrchr($files[$i]['url'],'.');
            $typesmall=strtolower($typemkhm);
           if($typesmall==".php" OR $typesmall==".rar" or $typesmall==".cgi" or $typesmall==".zip" or $typesmall==".pl" or $typesmall==".asp" or $typesmall==".aspx" or $typesmall==".html" or $typesmall==".htm" or $typesmall==".php3" or $typesmall==".php" or $typesmall==".phtml") $typemkhm="";
            $typemkhm=strtolower($typemkhm);
            $ms=$files[$i]['url'];
            $ms=strtolower($ms);
            if (eregi(".php", $ms)) $typemkhm="";
        }

        // Write if contents are available
        $k = strlen($content);
        if($k)
        {
            // Get unique cache ID (collision-free)
            $id = GetCacheID();
            // Create filename
            $f = 'imgcache/' . sprintf('%d', $id) . '.imgcache'.$typemkhm;

            // Open file
            $hFile = @fopen($f, 'wb');
            if($hFile)
            {
                // Write file contents
                $m = 0;
                $m = @fwrite($hFile, $content, $k);
                // Close file
                fclose($hFile);
                // Free some memory
                $content = '';
                // Replace URL's if successfully written
                if($m == $k)
                {
                    $old_url = $files[$i]['url'];
                    $new_url = $forum_home . $f;
                    $old_message = str_replace($old_url, $new_url, $old_message);

                }
            }
        }
    }

    return $old_message;
}
?>
